/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.b;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.c;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.FileRegistry;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import de.schlichtherle.truezip.file.TFile;
import java.net.URI;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class w
extends b
implements IResourceDeltaVisitor {
    private static final Logger c = LoggerFactory.getLogger(w.class);
    private final FileRegistry d;
    private final IProgressMonitor e;
    private String f;

    public w(ISoftwareSystemProvider systemProvider, FileRegistry fileRegistry, JavaModule module, IProgressMonitor monitor) {
        super(systemProvider, module);
        assert (fileRegistry != null) : "Parameter 'fileRegistry' of method 'SonargraphResourceDeltaVisitor' must not be null";
        this.d = fileRegistry;
        this.e = monitor;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        assert (delta != null) : "Parameter 'delta' of method 'visit' must not be null";
        if (this.e.isCanceled()) {
            return false;
        }
        IResource resource = delta.getResource();
        if (resource.getLocation() == null) {
            if (c.isDebugEnabled()) {
                c.debug("Resource '" + resource.toString() + "' has no location");
            }
            return true;
        }
        if (resource.getType() == 4) {
            return resource instanceof IProject;
        }
        if (resource.getType() == 2) {
            Optional<TFile> fileOpt = EclipseWorkspaceUtils.getFileOfResource(resource);
            if (!fileOpt.isPresent()) {
                return false;
            }
            String absolutePath = FileUtility.getIdentifyingPath((TFile)fileOpt.get());
            this.f = this.a(absolutePath) ? absolutePath : null;
            return this.f != null || this.b(absolutePath);
        }
        if (resource.getType() == 1) {
            if (this.f == null) {
                return false;
            }
            Optional<JavaFileType> fileTypeOpt = this.a(resource);
            if (!fileTypeOpt.isPresent()) {
                return false;
            }
            JavaFileType fileType = fileTypeOpt.get();
            switch (delta.getKind()) {
                case 1: {
                    URI added = resource.getLocationURI();
                    if (added == null) break;
                    TFile file = new TFile(added);
                    if (file.exists()) {
                        RootDirectoryPath currentRoot = this.a(this.f, fileType);
                        if (currentRoot != null) {
                            this.d().added(currentRoot, (IFileType)fileType, file);
                            break;
                        }
                        c.error("No sonargraph root directory found for: " + file.getAbsolutePath());
                        break;
                    }
                    c.warn("Added file not found for: " + FileUtility.getIdentifyingPath((TFile)file));
                    break;
                }
                case 2: {
                    URI removed = resource.getLocationURI();
                    if (removed == null) break;
                    String identifyingPathToBeRemoved = FileUtility.getIdentifyingPath((TFile)new TFile(removed));
                    FilePath toBeRemovedFilePath = this.d.getFilePath(identifyingPathToBeRemoved);
                    if (toBeRemovedFilePath != null) {
                        if (toBeRemovedFilePath.isValid()) {
                            this.d().deleted(toBeRemovedFilePath);
                            break;
                        }
                        c.warn("Deleted file not valid: " + identifyingPathToBeRemoved);
                        break;
                    }
                    c.warn("Deleted file not found for: " + identifyingPathToBeRemoved);
                    break;
                }
                case 4: {
                    if (com.hello2morrow.sonargraph.ide.eclipse.jobs.c.a(delta)) {
                        URI modified = resource.getLocationURI();
                        if (modified == null) break;
                        TFile modifiedFile = new TFile(modified);
                        String identifyingPathToBeModified = FileUtility.getIdentifyingPath((TFile)modifiedFile);
                        FilePath toBeModifiedFilePath = this.d.getFilePath(identifyingPathToBeModified);
                        if (toBeModifiedFilePath != null) {
                            if (toBeModifiedFilePath.isValid()) {
                                if (modifiedFile.exists()) {
                                    this.d().modified(toBeModifiedFilePath);
                                    break;
                                }
                                this.d().deleted(toBeModifiedFilePath);
                                break;
                            }
                            c.warn("Modified file not valid: " + identifyingPathToBeModified);
                            break;
                        }
                        c.warn("Modified file not found for: " + identifyingPathToBeModified);
                        break;
                    }
                    if (!c.isTraceEnabled()) break;
                    c.trace("Not a relevant change for {}", (Object)delta.getResource());
                }
            }
        }
        return false;
    }

    @Override
    public ModuleDelta b() {
        ModuleDelta delta = this.d();
        delta.finishCreation();
        return delta;
    }
}

