/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.core.model.workspace.IModule;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.b;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import de.schlichtherle.truezip.file.TFile;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class g
extends b
implements IResourceVisitor {
    static final Logger b = LoggerFactory.getLogger(g.class);
    private final IProgressMonitor d;
    private Map<String, FilePath> e;
    private String f;

    public g(ISoftwareSystemProvider systemProvider, JavaModule module, IProgressMonitor monitor) {
        super(systemProvider, module);
        assert (monitor != null) : "Parameter 'monitor' of method 'EclipseProjectFilesVisitor' must not be null";
        this.d = monitor;
    }

    public boolean visit(IResource resource) throws CoreException {
        if (this.d.isCanceled()) {
            return false;
        }
        if (resource.getType() == 4) {
            this.e = new HashMap<String, FilePath>();
            this.a().visitPresentFilePaths(new IFilePathListener(){

                public void filePathPresent(IModule module, FilePath filePath) {
                    if (!c && module == null) {
                        throw new AssertionError((Object)"Parameter 'module' of method 'filePathPresent' must not be null");
                    }
                    if (!c && filePath == null) {
                        throw new AssertionError((Object)"Parameter 'filePath' of method 'filePathPresent' must not be null");
                    }
                    TFile file = filePath.getFile();
                    if (!c && file == null) {
                        throw new AssertionError((Object)"'file' of method 'filePathPresent' must not be null");
                    }
                    String identifyingPath = FileUtility.getIdentifyingPath((TFile)file);
                    g.this.e.put(identifyingPath, filePath);
                    if (b.isTraceEnabled()) {
                        b.trace("File path present: " + identifyingPath);
                    }
                }
            }, new IModule[]{this.c()});
            return true;
        }
        if (resource.getType() == 2) {
            Optional<TFile> fileOpt = EclipseWorkspaceUtils.getFileOfResource(resource);
            if (!fileOpt.isPresent()) {
                b.debug("No file present for folder resource {}", (Object)resource);
                return false;
            }
            String absolutePath = FileUtility.getIdentifyingPath((TFile)fileOpt.get());
            this.f = this.a(absolutePath) ? absolutePath : null;
            return this.f != null || this.b(absolutePath);
        }
        if (resource.getType() == 1) {
            if (this.f == null) {
                return false;
            }
            assert (this.e != null) : "'m_sonargraphFiles' of method 'visit' must not be null. Have you called visit() on IProject?";
            Optional<JavaFileType> fileType = this.a(resource);
            if (!fileType.isPresent()) {
                return false;
            }
            Optional<TFile> fileOpt = EclipseWorkspaceUtils.getFileOfResource(resource);
            if (!fileOpt.isPresent()) {
                b.debug("No file present for file resource {}", (Object)resource);
                return false;
            }
            TFile file = fileOpt.get();
            String absolutePath = FileUtility.getIdentifyingPath((TFile)file);
            FilePath sonargraphFile = this.e.remove(absolutePath);
            if (file.exists()) {
                if (sonargraphFile != null) {
                    if (sonargraphFile.getTimestamp() < file.lastModified()) {
                        if (b.isTraceEnabled()) {
                            b.trace("Modified file: {}", (Object)absolutePath);
                        }
                        if (sonargraphFile.isValid()) {
                            this.d().modified(sonargraphFile);
                        } else {
                            b.warn("Modified file not valid: " + absolutePath);
                        }
                    }
                } else {
                    RootDirectoryPath currentRoot;
                    if (b.isTraceEnabled()) {
                        b.trace("Added file: {}", (Object)absolutePath);
                    }
                    if ((currentRoot = this.a(this.f, fileType.get())) != null) {
                        this.d().added(currentRoot, (IFileType)fileType.get(), new TFile(absolutePath));
                    } else {
                        b.error("No sonargraph root directory found for: " + absolutePath);
                    }
                }
            } else if (sonargraphFile != null) {
                if (b.isTraceEnabled()) {
                    b.trace("Deleted file: {}", (Object)absolutePath);
                }
                if (sonargraphFile.isValid()) {
                    this.d().deleted(sonargraphFile);
                } else {
                    b.warn("Deleted file not valid: " + absolutePath);
                }
            }
        }
        return false;
    }

    @Override
    public ModuleDelta b() {
        assert (this.e != null) : "'m_sonargraphFiles' of method 'finishDeltaCreation' must not be null. Method can only be called once!";
        ModuleDelta delta = this.d();
        for (Map.Entry<String, FilePath> nextEntry : this.e.entrySet()) {
            FilePath nextFilePath = nextEntry.getValue();
            if (nextFilePath != null) {
                if (b.isTraceEnabled()) {
                    b.trace("Deleted file: {}", (Object)nextFilePath.getFile().getAbsolutePath());
                }
                if (nextFilePath.isValid()) {
                    delta.deleted(nextFilePath);
                    continue;
                }
                b.warn("Deleted file not valid: " + nextFilePath.getFile().getAbsolutePath());
                continue;
            }
            b.warn("No file path for: " + nextEntry.getKey());
        }
        this.e = null;
        delta.finishCreation();
        return delta;
    }
}

