/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.core.command.common.d;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleMappingInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemInfoMessageCause;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemMappingInfo;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.g;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.o;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.p;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.t;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.FileRegistry;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class a
extends AbstractSonargraphEclipseJob {
    private static final Logger c = LoggerFactory.getLogger(a.class);

    protected a(IEventBroker eventBroker, ISoftwareSystemProvider provider, String name, JobType jobType, int priority) {
        super(eventBroker, provider, name, jobType, priority);
    }

    protected final IStatus a(IProgressMonitor monitor, TFile systemDirectory, FileRegistry fileRegistry, DynamicSystemInfo dynamicSystem, SystemMappingInfo systemMappingInfo) throws d, Exception, CoreException {
        OperationResult mappingResult = new OperationResult("Open software system");
        if (dynamicSystem.getModules().isEmpty()) {
            mappingResult.addError((OperationResult.IMessageCause)SystemInfoMessageCause.NO_MATCHING_MODULE_FOUND, "No mappings for system found", new Object[0]);
            UserInterfaceAdapter.b().a(() -> UserInterfaceAdapter.b().a(mappingResult));
            return Status.CANCEL_STATUS;
        }
        o task = new o(this.h(), fileRegistry, systemDirectory, dynamicSystem, systemMappingInfo);
        OperationResult openResult = task.a(monitor);
        if (monitor.isCanceled()) {
            EclipseWorkspaceUtils.clearSonargraphResourceProperties((IResource)ResourcesPlugin.getWorkspace().getRoot());
            return Status.CANCEL_STATUS;
        }
        if (openResult.isFailure()) {
            c.error("Failed to open system '{}'", (Object)systemDirectory.getAbsolutePath());
            EclipseWorkspaceUtils.clearSonargraphResourceProperties((IResource)ResourcesPlugin.getWorkspace().getRoot());
            return new Status(4, "com.hello2morrow.sonargraph.ide.eclipse", openResult.toString());
        }
        if (openResult.containsWarning() || openResult.containsError()) {
            UserInterfaceAdapter.b().a(openResult);
        }
        assert (this.h().hasSoftwareSystem()) : "No software system available";
        SoftwareSystem softwareSystem = this.h().getSoftwareSystem();
        if (softwareSystem.getState() == SoftwareSystemState.OPENED) {
            UserInterfaceAdapter.b().a("Reparse Required", "Executing a full reparse for system '" + systemDirectory.getName() + "'");
            c.debug("No snapshot available on system open or snapshot could not be applied. Executing a full reparse for system '{}'", (Object)systemDirectory.getAbsolutePath());
            IStatus result = t.a(this.h(), fileRegistry, monitor);
            return result.isOK() ? this.i() : result;
        }
        c.debug("Successfully opened system '{}' from snapshot", (Object)systemDirectory.getAbsolutePath());
        this.a(softwareSystem, systemMappingInfo, fileRegistry, monitor);
        return monitor.isCanceled() ? Status.CANCEL_STATUS : this.i();
    }

    private Status i() {
        return new Status(0, "com.hello2morrow.sonargraph.ide.eclipse", "OK Software system opened successfully.");
    }

    private void a(SoftwareSystem softwareSystem, SystemMappingInfo mappingInfo, FileRegistry fileRegistry, IProgressMonitor monitor) throws CoreException {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'executeDeltaRefresh' must not be null";
        assert (monitor != null) : "Parameter 'monitor' of method 'executeDeltaRefresh' must not be null";
        ArrayList<ModuleDelta> deltas = new ArrayList<ModuleDelta>();
        for (ModuleMappingInfo nextMapping : mappingInfo.getModuleMappings().stream().filter(m2 -> m2.isMappingDefined()).collect(Collectors.toList())) {
            if (monitor.isCanceled()) {
                return;
            }
            String moduleName = ((ModuleInfo)nextMapping.getSonargraphModule().get()).getName();
            JavaModule nextModule = (JavaModule)((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueChild((NamedElement.IFilter)new ShortNameFilter(moduleName), JavaModule.class);
            Optional<IProject> projectOpt = EclipseWorkspaceUtils.getProjectForModule(nextModule.getName());
            if (!projectOpt.isPresent()) {
                c.debug("Failed to determine project for module '{}'", (Object)nextModule.getName());
                continue;
            }
            IProject project = projectOpt.get();
            g visitor = new g(this.h(), nextModule, monitor);
            ModuleDelta moduleDelta = null;
            try {
                project.accept((IResourceVisitor)visitor);
                if (monitor.isCanceled()) {
                    return;
                }
                moduleDelta = visitor.b();
            }
            catch (CoreException ex) {
                c.error("Failed to determine files of project '{}'", (Object)project.getName(), (Object)ex);
            }
            if (moduleDelta == null || moduleDelta.isEmpty()) continue;
            deltas.add(moduleDelta);
        }
        if (deltas.isEmpty()) {
            c.debug("No module deltas determined");
            return;
        }
        p refreshTask = new p(this.h(), fileRegistry, deltas);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            c.debug("Executing delta refresh after system open with {} module deltas", (Object)deltas.size());
            refreshTask.a(monitor);
        }
        catch (d ex) {
            throw new CoreException((IStatus)new Status(4, "com.hello2morrow.sonargraph.ide.eclipse", "Delta refresh failed after system open", (Throwable)ex));
        }
    }
}

