/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.command.system.remoting.b;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.remoting.SelectionData;
import com.hello2morrow.sonargraph.ide.eclipse.foundation.common.b;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.model.ElementMapper;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.ui.swt.base.view.t;
import com.hello2morrow.sonargraph.ui.swt.base.view.w;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class EclipseRevealRemoteSelectionJob
extends AbstractSonargraphEclipseJob {
    private static final String c = "com.hello2morrow.sonargraph.ide.eclipse.jobs.selectionChanged";
    private final TreeViewer d;

    public EclipseRevealRemoteSelectionJob(ISonargraphEclipsePlugin plugin, TreeViewer viewer) {
        super(plugin.getSoftwareSystemProvider(), "Reveal Remote Selection", JobType.BACKGROUND, 10);
        assert (viewer != null) : "Parameter 'viewer' of method 'RevealRemoteSelectionJob' must not be null";
        this.d = viewer;
    }

    @Override
    protected AbstractSonargraphEclipseJob.Precondition a() {
        return AbstractSonargraphEclipseJob.Precondition.OPENED_SOFTWARE_SYSTEM;
    }

    @Override
    protected IStatus a(IProgressMonitor monitor) throws Exception {
        com.hello2morrow.sonargraph.core.command.system.remoting.b command = new com.hello2morrow.sonargraph.core.command.system.remoting.b(this.h(), new b.a(){

            public void a(OperationResultWithOutcome<StrictPair<List<SelectionData>, List<String>>> elements) {
                if (elements.isFailure()) {
                    UserInterfaceAdapter.b().a(elements);
                    return;
                }
                List toSelect = (List)((StrictPair)elements.getOutcome()).getFirst();
                if (toSelect.isEmpty()) {
                    List failedElements = (List)((StrictPair)elements.getOutcome()).getSecond();
                    UserInterfaceAdapter.b().b("Failed to Convert Elements", "Elements from remote selection could not be mapped to Eclipse workspace.\n" + failedElements.stream().collect(Collectors.joining(",\n")));
                    return;
                }
                EclipseRevealRemoteSelectionJob.this.a(toSelect);
            }
        });
        command.b((IWorkerContext)new b(monitor));
        return Status.OK_STATUS;
    }

    private void a(List<SelectionData> toSelect) {
        SelectionData select = toSelect.get(0);
        IJavaElement eclipseElement = ElementMapper.getEclipseElement(select.getElementToSelect());
        UserInterfaceAdapter.b().b(() -> {
            OperationResult openResult;
            IJavaElement source;
            this.d.setSelection((ISelection)new StructuredSelection((Object)eclipseElement));
            if (select.getSource() != null && (source = ElementMapper.getEclipseElement((NamedElement)select.getSource())) != null && source instanceof ICompilationUnit && (openResult = this.a((ICompilationUnit)source, select.getLine() - 1)).isFailure()) {
                UserInterfaceAdapter.b().a(openResult);
            }
        });
    }

    private OperationResult a(ICompilationUnit source, int line) {
        OperationResult result;
        block7: {
            result = new OperationResult("Open source '" + source.getElementName() + "' in editor");
            try {
                IEditorPart editorPart = JavaUI.openInEditor((IJavaElement)source);
                if (editorPart == null) {
                    result.addError((OperationResult.IMessageCause)RevealSelectionMessageCause.FAILED_TO_OPEN_RESOURCE_IN_EDITOR, "Failed to open editor for source " + source.getPath(), new Object[0]);
                    return result;
                }
                if (!(editorPart instanceof ITextEditor)) {
                    result.addError((OperationResult.IMessageCause)RevealSelectionMessageCause.FAILED_TO_OPEN_RESOURCE_IN_EDITOR, "Editor for source " + source.getPath() + " is not a text editor", new Object[0]);
                    return result;
                }
                ITextEditor editor = (ITextEditor)editorPart;
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                if (document == null) break block7;
                IRegion lineInfo = null;
                try {
                    lineInfo = document.getLineInformation(line);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (lineInfo != null) {
                    editor.selectAndReveal(lineInfo.getOffset(), lineInfo.getLength());
                }
            }
            catch (Exception ex) {
                String error = "Failed to open resource in editor " + source.getPath();
                result.addError((OperationResult.IMessageCause)RevealSelectionMessageCause.FAILED_TO_OPEN_RESOURCE_IN_EDITOR, error, new Object[]{ex});
            }
        }
        return result;
    }

    public static void a(IEclipseContext eclipseContext) {
        List<Element> noSelection = Arrays.asList(new Element[1]);
        for (t next : w.a((IEclipseContext)eclipseContext)) {
            if (!next.isActive()) continue;
            next.viewSelectionChanged(null, noSelection);
        }
    }

    @Override
    public boolean belongsTo(Object family) {
        return family instanceof EclipseRevealRemoteSelectionJob || super.belongsTo(family) || family == c;
    }

    private static enum RevealSelectionMessageCause implements OperationResult.IMessageCause
    {
        FAILED_TO_OPEN_RESOURCE_IN_EDITOR;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

