/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.b;

import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.ChangeType;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.RefactoringChange;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.RefactoringScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class e
implements IResourceChangeListener {
    private static final Logger b = LoggerFactory.getLogger(e.class);
    private final ChangeType c;
    private final List<Pair<IPath, IPath>> d = new ArrayList<Pair<IPath, IPath>>();
    private final Map<IPath, IResource> e = new HashMap<IPath, IResource>();
    private final Map<IPath, IResource> f = new HashMap<IPath, IResource>();
    private final Map<IPath, IResource> g = new HashMap<IPath, IResource>();
    private final List<IResource> h = new ArrayList<IResource>();
    private final List<IResource> i = new ArrayList<IResource>();
    private final List<IResource> j = new ArrayList<IResource>();
    private final List<IResource> k = new ArrayList<IResource>();
    private final Set<RefactoringScope> l;

    public e(ChangeType type, Set<RefactoringScope> scopes) {
        assert (type != null) : "Parameter 'type' of method 'RefactoringChangeListener' must not be null";
        assert (scopes != null && scopes.size() > 0) : "Parameter 'scopes' of method 'RefactoringChangeListener' must not be empty";
        this.c = type;
        this.l = scopes;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    if (resource instanceof IFolder) {
                        IJavaElement javaElement = JavaCore.create((IResource)resource);
                        if (javaElement == null) {
                            b.debug("No Java element found for folder: {}", (Object)resource.getFullPath());
                            return true;
                        }
                        IJavaElement parent = javaElement.getParent();
                        if (parent instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)parent).getKind() == 2) {
                            b.debug("Skipping delta of binary package fragment: {}", (Object)resource.getFullPath());
                            return false;
                        }
                        if ((delta.getKind() & 2) != 0) {
                            b.debug("Removed folder: {}", (Object)resource.getFullPath());
                            e.this.k.add(resource);
                        }
                        if ((delta.getKind() & 1) != 0) {
                            b.debug("Added folder: {}", (Object)resource.getFullPath());
                            e.this.h.add(resource);
                        }
                    } else if (resource instanceof IFile) {
                        IJavaElement javaElement = JavaCore.create((IResource)resource);
                        if (javaElement == null) {
                            b.debug("No Java element found for file: {}", (Object)resource.getFullPath());
                            return false;
                        }
                        if ((delta.getKind() & 2) != 0) {
                            b.debug("Removed file: {}", (Object)resource.getFullPath());
                            if (e.this.c == ChangeType.DELETE) {
                                e.this.d.add((Pair<IPath, IPath>)new Pair((Object)resource.getFullPath(), null));
                            }
                            e.this.f.put(resource.getFullPath(), resource);
                            e.this.j.add((IResource)resource.getParent());
                        } else if ((delta.getKind() & 1) != 0) {
                            b.debug("Added file: {}", (Object)resource.getFullPath());
                            e.this.i.add((IResource)resource.getParent());
                            e.this.e.put(resource.getFullPath(), resource);
                        } else if ((delta.getKind() & 4) != 0) {
                            if ((delta.getFlags() & 0x100) != 0) {
                                b.debug("Modified content {}", (Object)resource.getFullPath());
                                e.this.d.add((Pair<IPath, IPath>)new Pair((Object)resource.getFullPath(), (Object)resource.getFullPath()));
                                e.this.g.put(resource.getFullPath(), resource);
                            } else {
                                boolean markersChanged = (delta.getFlags() & 0x20000) != 0;
                                b.trace("Omitting {}, because content has not changed. Markers changed: {}", (Object)resource.getFullPath(), (Object)markersChanged);
                            }
                        }
                        if ((delta.getFlags() & 0x2000) != 0) {
                            b.debug("Moved {} -> {}", (Object)resource.getFullPath(), (Object)delta.getMovedToPath());
                            e.this.d.add((Pair<IPath, IPath>)new Pair((Object)resource.getFullPath(), (Object)delta.getMovedToPath()));
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException ex) {
            b.error("Failed to process change event: " + event, (Throwable)ex);
        }
    }

    public List<RefactoringChange> a() {
        b.debug("Determine changes for type {}, scopes {}", (Object)this.c.name(), (Object)StringUtility.concat((Collection)this.l.stream().map(s2 -> s2.name()).collect(Collectors.toList()), (String)","));
        ArrayList<RefactoringChange> result = new ArrayList<RefactoringChange>();
        if (this.c != ChangeType.DELETE) {
            this.h.retainAll(this.i);
            this.k.retainAll(this.j);
        }
        if (this.c == ChangeType.MODIFY && this.l.contains((Object)RefactoringScope.PACKAGE)) assert (this.k.size() == this.h.size()) : "Different number of removed and added packages: " + this.k.size() + " != " + this.h.size();
        int i2 = 0;
        while (i2 < this.k.size()) {
            IResource nextRemoved = this.k.get(i2);
            if (this.c == ChangeType.DELETE) {
                result.add(new RefactoringChange(nextRemoved));
            } else {
                IResource nextAdded = this.h.get(i2);
                result.add(new RefactoringChange(nextRemoved, nextAdded));
            }
            ++i2;
        }
        for (Pair<IPath, IPath> next : this.d) {
            IResource original;
            if (((IPath)next.getFirst()).equals(next.getSecond())) {
                original = this.g.get(next.getFirst());
                result.add(new RefactoringChange(original, original));
                continue;
            }
            original = this.f.get(next.getFirst());
            if (next.getSecond() == null) {
                result.add(new RefactoringChange(original));
                continue;
            }
            IResource target = this.e.get(next.getSecond());
            assert (target != null) : "no entry found for added resource: " + next.getSecond();
            result.add(new RefactoringChange(original, target));
        }
        result.sort(new RefactoringChange.Comparator());
        return result;
    }
}

